/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xperfdef.h
 * -----------------------------------------------------------------*/

#ifndef XPERFDEFS_H_INCLUDED                               
#define XPERFDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif

/* ---------------------------------------------------------------
 * Type Definitions for Performance Functions
 * --------------------------------------------------------------- */

/* transient properties of a performance sequencer */

/* do NOT (NEVER EVER) touch these offset values... */
#define BX_PERFSEQ_PROP_OFFSET   11

/* Number of transients per line */
#define BX_PERFLINETRAN_SIZE  2 /* current, nextstate; may NEVER exceed 4 (Robert Siegmund) */

CLI typedef enum {
  BX_PERFTRAN_STATE     =0,      /* @state     */
  BX_PERFTRAN_NEXTSTATE =1       /* @nextstate */
} bx_perftrantype;

#define BX_PERF_CONDITION_OFFSET   14

/* Number of conditions per line */
#define BX_PERFLINECOND_SIZE  5

CLI typedef enum {
  BX_PERFCOND_X,       /* @x         */
  BX_PERFCOND_CTRAINC, /* @ctrainc   */
  BX_PERFCOND_CTRBINC, /* @ctrbinc   */
  BX_PERFCOND_FBADEC,  /* @fbadec    */
  BX_PERFCOND_FBALOAD  /* @fbaload   */
} bx_perfcondtype;

/* these are the performance measure generic properties */

/* Robert Siegmund's values chris TBD: change names */
#define BX_PERFSEQ_GEN_PREL_OFFSET   10
#define BX_PERFSEQ_GEN_CAMODE_OFFSET 126

/* Number of generic properties for each sequencer */
#define BX_PERFGEN_SIZE 2

CLI typedef enum {
  BX_PERFGEN_FBA,        /* @fba          */
  BX_PERFGEN_CTRAMODE    /* @ctramode     */
} bx_perfgentype;

CLI /* DEF_START ~G_BX_PerfSeqCtrAMode */
#define BX_PERFGEN_CTRAMODE_INC        0    
#define BX_PERFGEN_CTRAMODE_INCBYTEN   1   
CLI /* DEF_END */


/* these are the counter identifiers of a performance measure */
#define BX_PERFCTR_SIZE 6

CLI /* DEF_START ~G_BX_PerfCntIdent */
#define BX_PERFCTR_A         0          
#define BX_PERFCTR_B         1         
#define BX_PERFCTR_REF       2          
#define BX_PERFCTR_A_HI      3          
#define BX_PERFCTR_B_HI      4         
#define BX_PERFCTR_REF_HI    5      
CLI /* DEF_END */


CLI /* DEF_START ~G_BX_PerfSeq */
#define BX_PERFMEAS_0         0   
#define BX_PERFMEAS_1         1
#define BX_PERFMEAS_2         2
#define BX_PERFMEAS_3         3 
CLI /* DEF_END */

#endif


